/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xobj;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import uk.co.demon.obelisk.xobj.Expr;
import uk.co.demon.obelisk.xobj.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Module {
    private String name = null;
    private final String target;
    private final boolean bigEndian;
    private final int byteSize;
    private final long byteMask;
    private Vector<Section> sections = new Vector();
    private Hashtable<String, Expr> globals = new Hashtable();

    public Module(String target, boolean bigEndian) {
        this(target, bigEndian, 8);
    }

    public Module(String target, boolean bigEndian, int byteSize) {
        this.target = target;
        this.bigEndian = bigEndian;
        this.byteSize = byteSize;
        this.byteMask = (1L << byteSize) - 1L;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public long getByteMask() {
        return this.byteMask;
    }

    public Vector<String> getGlobals() {
        Vector<String> result = new Vector<String>();
        Enumeration<String> cursor = this.globals.keys();
        while (cursor.hasMoreElements()) {
            result.add(cursor.nextElement());
        }
        return result;
    }

    public Vector<Section> getSections() {
        return this.sections;
    }

    public Section findSection(String name) {
        Section section;
        int index = 0;
        while (index < this.sections.size()) {
            section = this.sections.elementAt(index);
            if (section.isRelative() && section.getName().equals(name)) {
                return section;
            }
            ++index;
        }
        section = new Section(this, name);
        this.sections.add(section);
        return section;
    }

    public Section findSection(String name, long start) {
        Section section;
        int index = 0;
        while (index < this.sections.size()) {
            section = this.sections.elementAt(index);
            if (section.isAbsolute() && section.getStart() == start && section.getName().equals(name)) {
                return section;
            }
            ++index;
        }
        section = new Section(this, name, start);
        this.sections.add(section);
        return section;
    }

    public void addGlobal(String name, Expr expr) {
        this.globals.put(name, expr);
    }

    public Expr getGlobal(String name) {
        return this.globals.get(name);
    }

    public void clear() {
        int index = 0;
        while (index < this.sections.size()) {
            this.sections.elementAt(index).clear();
            ++index;
        }
        this.globals.clear();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<module");
        buffer.append(" target='" + this.target + "'");
        buffer.append(" endian='" + (this.bigEndian ? "big" : "little") + "'");
        buffer.append(" byteSize='" + this.byteSize + "'");
        buffer.append(" name='" + this.name + "'>");
        int index = 0;
        while (index < this.sections.size()) {
            buffer.append(this.sections.elementAt(index).toString());
            ++index;
        }
        Enumeration<String> cursor = this.globals.keys();
        while (cursor.hasMoreElements()) {
            String name = cursor.nextElement();
            Expr expr = this.globals.get(name);
            buffer.append("<gbl>" + name + expr + "</gbl>");
        }
        buffer.append("</module>");
        return buffer.toString();
    }
}

